import { lighten } from 'polished';
import styled from 'styled-components';
import { COLORS } from '../../constants/colors';

export const InputStyled = styled.input`
  width: 100%;
  padding: 12px 14px;
  font-size: 16px;
  border: solid 2px ${COLORS.color8};

  :focus {
    border: solid 2px ${COLORS.color4};
    outline: none;
  }

  :hover:not(:focus) {
    border-color: ${lighten(0.2, COLORS.color8)};
  }

  transition: border-color 0.1s ease-in-out;
`;
