import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_Condition"

    // unique for every action
    actionId: 0x01
    actionName: QT_TRANSLATE_NOOP("Condition", "Condition")
    actionTitle: qsTr("Condition:\n??? ? ???")
    actionToolTip: qsTr("Choose branch according to condition result")
    actionOutputCount: 2

    parameterDialogSource: 'ConditionDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("Condition", "LeftVar")
            paramType: "int|float"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("Condition", "RightVar")
            paramType: "int|float"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        parametersModel.append(
                    {
                        "paramName": qsTranslate("Condition", "Condition"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : ">",
                                "desc"    : qsTranslate("Condition", "Greater"),
                                "value"   : 0
                            },
                            {
                                "varName" : "<",
                                "desc"    : qsTranslate("Condition", "Less"),
                                "value"   : 1
                            },
                            {
                                "varName" : "<=",
                                "desc"    : qsTranslate("Condition", "Less or equal"),
                                "value"   : 2
                            },
                            {
                                "varName" : ">=",
                                "desc"    : qsTranslate("Condition", "Greater or equal"),
                                "value"   : 3
                            },
                            {
                                "varName" : "==",
                                "desc"    : qsTranslate("Condition", "Equal"),
                                "value"   : 4
                            },
                            {
                                "varName" : "!=",
                                "desc"    : qsTranslate("Condition", "Not equal"),
                                "value"   : 5
                            }]
                    });
    }

    function setTitle() {
        var leftStr  = parametersModel.get(0).varName
        var rightStr = parametersModel.get(1).varName
        var condStr  = parametersModel.get(2).varName

        if (leftStr.length === 0)
            leftStr = qsTr("???")

        if (rightStr.length === 0)
            rightStr = qsTr("???")

        if (condStr.length === 0)
            condStr = qsTr("???")

        actionTitle = qsTr("%1 %2 %3")
                .arg(leftStr).arg(condStr).arg(rightStr)
    }
}
