import QtQuick 2.0
import QtQuick.Layouts 1.1

BaseParameterDialog {
    id: mathParametersDialog
    objectName: "mathParametersDialog"

    property int dstParamWidth:       Math.round(100 * kDPI)
    property int equalSignParamWidth: Math.round(16 * kDPI)
    property int srcParamWidth:       Math.round(100 * kDPI)

    width: dstParamWidth
           + equalSignParamWidth
           + srcParamWidth
           + parameterItemSpacing * 2
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        var l_height = titleHeight
                + parameterItemHeight
                + parameterItemSpacing
        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView
        RowLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            height: parameterItemHeight
            spacing: parameterItemSpacing

            VarNameItem {
                width: dstParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 0
            }
            Text {
                width: equalSignParamWidth
                height: paintedHeight
                text: " = "
            }
            VarNameItem {
                width: srcParamWidth
                Layout.fillHeight: true
                paramModel: parametersModel
                paramIndex: 1
            }
        }
    }
}
