import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetWiFiNetwork"

    // unique for every action
    actionId: 0x1A
    actionName: QT_TRANSLATE_NOOP("SetWiFiNetwork", "SetWiFiNetwork")
    actionTitle: qsTr("Set WiFi network:\n???")
    actionToolTip: qsTr("Set WiFi network")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SetWiFiNetwork", "SSID")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SetWiFiNetwork", "Password")
            paramType: "string"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        parametersModel.insert(1,
                               {
                                   "paramName": qsTranslate("SetWiFiNetwork", "Authentication type"),
                                   "paramType": categoryList,
                                   "varCategory": categoryList,
                                   "varName": "",
                                   "varBaseCategory": "",
                                   "isEditable": false,
                                   "paramList" :
                                       [{
                                           "varName" : "Open",
                                           "desc"    : qsTranslate("SetWiFiNetwork", "Open"),
                                           "value"   : 0
                                       },
                                       {
                                           "varName" : "WEP",
                                           "desc"    : qsTranslate("SetWiFiNetwork", "WEP"),
                                           "value"   : 1
                                       },
                                       {
                                           "varName" : "WPA/WPA2",
                                           "desc"    : qsTranslate("SetWiFiNetwork", "WPA/WPA2"),
                                           "value"   : 2
                                       }]
                               });
        parametersModel.insert(3,
                               {
                                   "paramName": qsTranslate("SetWiFiNetwork", "Mode"),
                                   "paramType": categoryList,
                                   "varCategory": categoryList,
                                   "varName": "",
                                   "varBaseCategory": "",
                                   "isEditable": false,
                                   "paramList" :
                                       [{
                                           "varName" : "Client",
                                           "desc"    : qsTranslate("SetWiFiNetwork", "Client"),
                                           "value"   : 0
                                       },
                                       {
                                           "varName" : "Access point",
                                           "desc"    : qsTranslate("SetWiFiNetwork", "Access point"),
                                           "value"   : 1
                                       }]
                               });			       
    }

    function setTitle() {
        actionTitle = qsTr("Set WiFi network:\n\"%1\"").arg(parametersModel.get(0).varName);
    }
}
