import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableNavigationUnit"

    // unique for every action
    actionId: 0x14
    actionName: QT_TRANSLATE_NOOP("EnableNavigationUnit", "EnableNavigationUnit")
    actionTitle: qsTr("Navigation unit:\nEnable = ???")
    actionToolTip: qsTr("Enable navigation unit")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableNavigationUnit", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable navigation unit");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable navigation unit");
        else
            actionTitle = qsTr("Navigation unit:\nEnable = %1").arg(enableStr);
    }
}
