var startingMouse;
var posnInWindow;

function startDrag(item, source, mouse)
{
    console.debug('startDrag:')
    console.debug(item.objectName + ':' + item.x  + ' ' + item.y)
    console.debug('mouse: ' + mouse.x + ' ' + mouse.y)
    console.debug('parent:' + item.parent.objectName)

    posnInWindow = item.mapToItem(diagramContainer.diagramField, 0, 0);
    posnInWindow.x += item.width / 2
    posnInWindow.y += item.height / 2
    startingMouse = { x: mouse.x, y: mouse.y }
    diagramContainer.diagramField.loadAndCreateItem(source, posnInWindow);
    diagramContainer.diagramField.dynamicItem.pageIndex = diagramContainer.pageIndex;
    continueDrag(mouse)
    console.debug("posnInWindow: " + posnInWindow.x + ' ' + posnInWindow.y)
    console.debug("startingMouse:" + startingMouse.x + ' ' + startingMouse.y)
}


function continueDrag(mouse)
{
    if (diagramContainer.diagramField.dynamicItem === null)
        return;

    diagramContainer.diagramField.dynamicItem.endpoint2.x = mouse.x + posnInWindow.x - startingMouse.x;
    diagramContainer.diagramField.dynamicItem.endpoint2.y = mouse.y + posnInWindow.y - startingMouse.y;
    diagramContainer.diagramField.recalculateLine(
                    diagramContainer.diagramField.dynamicItem);
}

function endDrag(mouse)
{
    if (diagramContainer.diagramField.dynamicItem === null)
        return;

    console.debug('mouse:              ' +mouse.x + ' ' + mouse.y)
    console.debug('dynamicItem:        ', diagramContainer.diagramField.dynamicItem.endpoint2.x,
                                        diagramContainer.diagramField.dynamicItem.endpoint2.y)
    console.debug('diagramField:       ' +diagramContainer.diagramField.width + ' ' + diagramContainer.diagramField.height)

    // Drop only in diagramField
    if ((0 < diagramContainer.diagramField.dynamicItem.endpoint2.x)
            && (diagramContainer.diagramField.dynamicItem.endpoint2.x < diagramContainer.diagramField.width)
            && (0 < diagramContainer.diagramField.dynamicItem.endpoint2.y)
            && (diagramContainer.diagramField.dynamicItem.endpoint2.y < diagramContainer.diagramField.height))
    {
        diagramContainer.diagramField.draggedItemCount += 1;
        diagramContainer.diagramField.dynamicItem.created = true;
        diagramContainer.diagramField.dragFinished(mouse)
        diagramContainer.diagramField.dynamicItem = null;
        console.debug('diagramContainer.diagramField.dynamicItem remained');

        diagramContainer.diagramField.dumpChildren();
    }
    else
    {
        diagramContainer.diagramField.dynamicItem.destroy();
        diagramContainer.diagramField.dynamicItem = null;
        console.debug('diagramContainer.diagramField.dynamicItem destroyed');
    }
    delete diagramContainer.diagramField.dynamicComponent;
    diagramContainer.diagramField.dynamicComponent = null;
    console.debug('-----------------------------');
}

function cancelDrag()
{
    if (diagramContainer.diagramField.dynamicItem !== null) {
        diagramContainer.diagramField.dynamicItem.destroy();
        diagramContainer.diagramField.dynamicItem = null;
    }

    delete diagramContainer.diagramField.dynamicComponent;
    diagramContainer.diagramField.dynamicComponent = null;

    console.debug('diagramContainer.diagramField.dynamicItem canceled');
    console.debug('-----------------------------');
}

function generateVarName(item){
    var name = "result %1".arg(item);
    varsModel.addVar("global", "int", "Algorithms", name, name);
    return name;
}
