import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_GetParameter"

    // unique for every action
    actionId: 0x07
    actionName: QT_TRANSLATE_NOOP("GetParameter", "GetParameter")
    actionTitle: qsTr("GetParameter:\n???")
    actionToolTip: qsTr("Choose parameter to use in chain");
    actionOutputCount: 1

    parameterDialogSource: 'GetParameterDialog.qml'

    actionType: "systemEvent"
    view_type: view_types.get_param // Так же определяет тип ветку разбора при созранении скрипта

    parametersModel: ListModel {
        id: core_model

        onDataChanged: {
            setTitle();
            sendResultToNext();
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("GetParameter", "Parameter")
            paramType: "int"
            varCategory: "localConst"
            varAllowance: "filter"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("GetParameter", "Result")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var _parameter  = parametersModel.get(0).varName

        if (_parameter.length === 0)
            _parameter = qsTr("???")

        actionTitle = qsTr("Get:\n  %1").arg(_parameter)
    }
}
