import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_DiagMessage"

    // unique for every action
    actionId: 0x09
    actionName: QT_TRANSLATE_NOOP("DiagMessage", "DiagMessage")
    actionTitle: qsTr("DiagMessage:\n???")
    actionToolTip: qsTr("Diagnostic message")

    permanentParametersCount: 1
    nonPermanentParameterName: QT_TRANSLATE_NOOP("DiagMessage", "Argument")
    nonPermanentParamType: "int|string"
    nonPermanentVarCategory: ".*"

    parametersModel: ListModel {

        onDataChanged:  setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("DiagMessage", "Message")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var messageStr = parametersModel.get(0).varName

        if (messageStr.length === 0)
            messageStr = qsTr("???")

        var str = qsTr("DiagMessage:\n\"%1\"").arg(messageStr);
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            str += "\n" + qsTranslate("DiagMessage", nonPermanentParameterName)
                + ": " + parametersModel.get(i).varName;
        }
        actionTitle = str;
    }
}
