import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

Rectangle {
    id: statusPanel
    objectName: "statusPanel"

    property alias scaleFactorSlider: scaleFactorSlider
    property alias diagnosticsButton: diagnosticsButton
    
    color: colorStatus
    border.width: 1
    border.color: colorBorder
    
    RowLayout {
        id: statusLayout
        objectName: "statusLayout"
        
        anchors.fill: parent
        anchors.rightMargin: standardMargin
        
        Button {
            id: diagnosticsButton
            objectName: "diagnosticsButton"
            
            Layout.fillWidth: true
            Layout.fillHeight: true
            checkable: true
            checked: scriptGenerator.diagnosticsChecked
            text: qsTr("Diagnostics")
            
            style: ActionButtonStyle {
                uncheckedAngle: -90
                animationDuration: 400
            }
            
            onClicked: {
                scriptGenerator.diagnosticsChecked = checked;
            }
        }
        Text {
            id: scaleText
            font.family: "Verdana"
            font.pointSize: 8
            font.bold: true
            color: colorTextPanel
            text: qsTr("%1%").arg(diagramContainer.diagramField.diagramScaleFactor.toFixed(1) * 100)
        }
        Item {
            width: Math.round(112 * kDPI)
            Layout.fillHeight: true
            Slider {
                id: scaleFactorSlider
                objectName: "scaleSlider"
                
                anchors.fill: parent
                value: 1.0
                minimumValue: diagramContainer.scaleFactorMin
                maximumValue: diagramContainer.scaleFactorMax
                stepSize: 0.1
                
                function increase() { value += stepSize; }
                function decrease() { value -= stepSize; }
                
                style: SliderStyle {
                    groove: Rectangle {
                        implicitWidth: Math.round(200 * kDPI)
                        implicitHeight: Math.round(5 * kDPI)
                        radius: Math.round(3 * kDPI)
                        gradient: Gradient {
                            GradientStop { position: 0.0; color: colorGroup }
                            GradientStop { position: 1.0; color: colorPanel }
                        }
                        border.width: 1
                        border.color: colorPanel
                    }
                    handle: Rectangle {
                        anchors.centerIn: parent
                        implicitWidth: Math.round(14 * kDPI)
                        implicitHeight: Math.round(14 * kDPI)
                        color: control.pressed ? colorGroup : colorHandle
                        border.color: colorPanel
                        border.width: 1
                        radius: Math.round(7 * kDPI)
                    }
                }
                
                Binding {
                    target: scaleFactorSlider
                    property: "value"
                    value: diagramContainer.diagramField.diagramScaleFactor
                }
                
                onValueChanged: {
                    var controlPoint = Qt.point(diagramContainer.width/2,
                                                diagramContainer.height/2)
                    
                    console.debug(objectName, "onValueChanged:", value,
                                  controlPoint.x, controlPoint.y)
                    var fieldPoint = diagramContainer.mapToItem(
                                diagramContainer.diagramField, controlPoint.x, controlPoint.y)
                    
                    diagramContainer.diagramField.diagramScaleFactor = value
                    
                    var resultPoint = diagramContainer.mapFromItem(
                                diagramContainer.diagramField, fieldPoint.x, fieldPoint.y)
                    diagramContainer.diagramField.diagramCenterPointX -= resultPoint.x - controlPoint.x
                    diagramContainer.diagramField.diagramCenterPointY -= resultPoint.y - controlPoint.y
                }
            }
        }
    }
}
