import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_GetTemperature"

    // unique for every action
    actionId: 0x12
    actionName: QT_TRANSLATE_NOOP("GetTemperature", "GetTemperature")
    actionTitle: qsTr("Get temperature:\n??? <- ID: ???")
    actionToolTip: qsTr("Get temperature on specified thermometer ID")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("InitVar", "DstVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("InitVar", "Thermometer ID")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var dstVarStr = parametersModel.get(0).varName
        var tempIdStr = parametersModel.get(1).varName

        if (dstVarStr.length === 0)
            dstVarStr = qsTr("???")

        if (tempIdStr.length === 0)
            tempIdStr = qsTr("???")

        actionTitle = qsTr("Get temperature:\n%1 <- ID: %2")
                .arg(dstVarStr).arg(tempIdStr)
    }
}
