import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: simpleFilterDialog
    objectName: "simpleFilterDialog"

    property int leftParamWidth: 260

    width: leftParamWidth
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        // Функция отвечающя за применение окончательного размера окна диалога
        // Если нужно поменять размер - данные нужно менять в ней.
        var l_height = titleHeight
                + parameterItemHeight*2
                + parameterItemSpacing

        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);

        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView

        ColumnLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: parameterItemSpacing * 2

            Row {
                id: conditionLayout

                height: parameterItemHeight
                width: simpleFilterDialog.width
                Text{
                    id: var_lable
                    width: 150
                    height: parameterItemHeight
                    wrapMode: TextEdit.WordWrap
                    horizontalAlignment: Text.AlignRight
                    verticalAlignment: Text.AlignVCenter
                    text: (parametersModel.get(1) === undefined) ? "" : parametersModel.get(1).paramName
                }
                Text{
                    text: "  "
                }
                VarNameItem {
                    id: var_name
                    width: 100
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 1
                    inputValidator: /[0-9]+/
                }
            }
        }
    }
}
