import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_RunCommand"

    // unique for every action
    actionId: 0x21
    actionName: QT_TRANSLATE_NOOP("RunCommand", "RunCommand")
    actionTitle: qsTr("Run command:\n???")
    actionToolTip: qsTr("Run command")

    permanentParametersCount: 1
    nonPermanentParameterName: QT_TRANSLATE_NOOP("RunCommand", "Argument")
    nonPermanentParamType: "int"
    nonPermanentVarCategory: "global|localConst"

    parametersModel: ListModel {

        onDataChanged:  setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("RunCommand", "Command")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var messageStr = parametersModel.get(0).varName

        if (messageStr.length === 0)
            messageStr = qsTr("???")

        var str = qsTr("Run command:\n\"%1\"").arg(messageStr);
        for (var i = permanentParametersCount; i < parametersModel.count; ++i) {
            str += "\n" + qsTranslate("RunCommand", nonPermanentParameterName)
                + ": " + parametersModel.get(i).varName;
        }
        actionTitle = str;
    }
}
