import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_ConditionWithTimeout"

    // unique for every action
    actionId: 0x18
    actionName: QT_TRANSLATE_NOOP("ConditionWithTimeout", "ConditionWithTimeout")
    actionTitle: qsTr("Condition:\n??? ? ???\nTimeout = ???")
    actionToolTip: qsTr("Choose branch according to condition waiting for true result during timeout")
    actionOutputCount: 2

    parameterDialogSource: 'ConditionDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("ConditionWithTimeout", "LeftVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ConditionWithTimeout", "RightVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        // <- insert position
        ListElement {
            paramName: qsTr("Timeout [ms]")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        parametersModel.insert(2,
                    {
                        "paramName": qsTranslate("ConditionWithTimeout", "Condition"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : ">",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Greater"),
                                "value"   : 0
                            },
                            {
                                "varName" : "<",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Less"),
                                "value"   : 1
                            },
                            {
                                "varName" : "<=",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Less or equal"),
                                "value"   : 2
                            },
                            {
                                "varName" : ">=",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Greater or equal"),
                                "value"   : 3
                            },
                            {
                                "varName" : "==",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Equal"),
                                "value"   : 4
                            },
                            {
                                "varName" : "!=",
                                "desc"    : qsTranslate("ConditionWithTimeout", "Not equal"),
                                "value"   : 5
                            }]
                    });
    }

    function setTitle() {
        var leftStr  = parametersModel.get(0).varName
        var rightStr = parametersModel.get(1).varName
        var condStr  = parametersModel.get(2).varName
        var timeoutStr = parametersModel.get(3).varName

        if (leftStr.length === 0)
            leftStr = qsTr("???")

        if (rightStr.length === 0)
            rightStr = qsTr("???")

        if (condStr.length === 0)
            condStr = qsTr("???")

        if (timeoutStr.length === 0)
            timeoutStr = qsTr("???")

        actionTitle = qsTr("%1 %2 %3\nTimeout = %4")
                .arg(leftStr).arg(condStr).arg(rightStr).arg(timeoutStr)
    }
}
