import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SendCanMessage"

    // unique for every action
    actionId: 0x1D
    actionName: QT_TRANSLATE_NOOP("SendCanMessage", "SendCanMessage")
    actionTitle: qsTr("Send CAN Message: \"???\"");
    actionToolTip: qsTr("Send CAN Message")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement { // 0
            paramName: QT_TRANSLATE_NOOP("SendCanMessage", "Message Id")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        //ListElement { // 1
            // Сюда будет всавлен элемент для выбора параметра битности сообщения
        //}

        ListElement { // 2
            paramName: QT_TRANSLATE_NOOP("SendCanMessage", "Message Byte Length")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 4
            paramName: QT_TRANSLATE_NOOP("SendCanMessage", "Message Data Low Bytes")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement { // 5
            paramName: QT_TRANSLATE_NOOP("SendCanMessage", "Message Data High Bytes")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        Component.onCompleted: {
            var bits_parameter_pos = 1;
            parametersModel.insert(bits_parameter_pos,
                        {
                            "paramName": qsTranslate("SendCanMessage", "Message Bits"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "",
                            "varBaseCategory": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTranslate("SendCanMessage", "11-bits"),
                                    "desc"    : qsTranslate("SendCanMessage", "11-bits"),
                                    "value"   : 0 // Standard Value
                                },
                                {
                                    "varName" : qsTranslate("SendCanMessage", "29-bits"),
                                    "desc"    : qsTranslate("SendCanMessage", "29-bits"),
                                    "value"   : 1 // Extended Value
                                }
                                ]
                        });

            parametersModel.append(
                        {
                            "paramName": qsTranslate("SendCanMessage", "Interface"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "CAN0",
                            "varBaseCategory": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : "CAN0",
                                    "value"   : 0
                                },
                                {
                                    "varName" : "CAN1",
                                    "value"   : 1
                                }]
                        });

			setTitle()
        }


        function setTitle() {
            var mid = parametersModel.get(0).varName
            if (mid.length === 0)
                mid = qsTr("???")

            var bits = parametersModel.get(1).varName
            if (bits.length === 0)
                bits = qsTr("???")

            var length = parametersModel.get(2).varName
            if (length.length === 0)
                length = qsTr("???")

            var low = parametersModel.get(3).varName
            if (low.length === 0)
                low = qsTr("???")

            var high = parametersModel.get(4).varName
            if (high.length === 0)
                high = qsTr("???")
				
            var canIndex = parametersModel.get(5).varName

            actionTitle = qsTr("Send %1 message\n id: %2\n %3\nLength: %4\nLow Bytes: %5\nHigh Bytes %6").arg(canIndex).arg(mid).arg(bits).arg(length).arg(low).arg(high)
        }
    }
}
