import QtQuick 2.0

ListModel {
    id: eventsModel
    objectName: "eventsModel"

    default property list<ListModel> devModels

    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Device start")
        image: "images/icon_rect_green.svg"
        source: 'actions/DeviceStart.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Incoming SMS")
        image: "images/icon_rect_green.svg"
        source: 'actions/IncomingSMS.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Incoming call")
        image: "images/icon_rect_green.svg"
        source: 'actions/IncomingCall.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "RS485 Handler")
        image: "images/icon_rect_green.svg"
        source: 'actions/RS485Handler.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Incoming command")
        image: "images/icon_rect_green.svg"
        source: 'actions/IncomingCommand.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Should make photo")
        image: "images/icon_rect_green.svg"
        source: 'actions/MakePhotoEvent.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("eventsModel", "Finish")
        image: "images/icon_rect_red.svg"
        source: 'actions/Finish.qml'
    }

    onDevModelsChanged:
    {
        if (!DEVELOPER_MODE) return;
        var i = devModels.length - 1;
        if (i < 0) return;

        for (var j = 0; j < devModels[i].count; j++)
            eventsModel.append(devModels[i].get(j));
     }
}
