// Данный набор функций и объектов используется для расчета срених величин
// И заточен для работы с TarTableFilter.qml

var average_data = [];
var amount_of_valid_elements = 5;
var disperse_percent = 25;

function clearAvgData() {
    average_data = [];
}

function addAvgData(data){
    average_data.push(data);
}

// Вычисление простого среднего
function evalAvg(){
    if (average_data.length<amount_of_valid_elements) {
        return evalSimpleAvg()
    }
    // вычисляем по последним amount_of_valid_elements элементам
    return evalM(amount_of_valid_elements);
}

function evalSimpleAvg(){
    var sum = 0;
    var i = 0;
    for (i=0; i<average_data.length; ++i) {
        sum += average_data[i];
    }
    return sum/i;
}

function getMeasurementCount(){
    return average_data.length;
}

function isSustained(){
    if (average_data.length < amount_of_valid_elements) {
        return false
    }

    // Идея следующая мы всегда берем определенный набор последних значений, напрмиер 10.
    // Считаем среднее (M). Считаем Дисперсию (D)  и среднеквалдратичное отклонение (d).
    // Далее если d/M меньшеопределенной величины, то считаем что процесс устоялся.
    // Ну, можно использовать (d/M)*100, чтобы удобно было в % сравнивать.
    // Здесь: https://abc.vvsu.ru/books/pr_stat1/page0010.asp Есть пример и пример суждений о процессе
    // Коэффициент вариации позволяет судить об однородности совокупности:
    // -  < 17% – абсолютно однородная;
    // -  17–33%% – достаточно однородная;
    // -  35–40%% – недостаточно однородная;
    // -  40–60%% – это говорит о большой колеблемости совокупности.

    // Пока для круглого счета, от балды возьмем 10%. Возможно стоит взять меньше
    // Все же мы это делаем для тарировки и нужно достаточно точно определять показания датчиков.

    // Мат ожидание
    var M = evalM(amount_of_valid_elements);

    // Дисперсия
    var D = evalD(amount_of_valid_elements, M);
    var d = Math.sqrt(D);
    console.log("M = ", M)
    console.log("D = ", D)
    console.log("d = ", d)
    console.log("(d/M)*100 = ", (d/M)*100);

    if ((d/M)*100 <= disperse_percent) {
        return true;
    }
    return false;
}

function evalM(count_of_last_elements) {
    var sum = 0;
    var i = 0;
    var count = average_data.length;
    for (i=(count - count_of_last_elements); i<count; ++i) {
        sum += average_data[i];
    }
    return sum/count_of_last_elements;
}

function evalD(count_of_last_elements, M){
    var disperse = 0;
    var i = 0;
    var count = average_data.length;
    for (i=(count - count_of_last_elements); i<count; ++i) {
        disperse += Math.pow(average_data[i] - M, 2);
    }
    return disperse/count_of_last_elements;
}






