import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_Math"

    // unique for every action
    actionId: 0x08
    actionName: QT_TRANSLATE_NOOP("Math", "Math")
    actionTitle: qsTr("Mathematics:\n??? = ??? ? ???")
    actionToolTip: qsTr("Mathematical operation")

    parameterDialogSource: 'MathDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("Math", "LeftVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("Math", "RightVar")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        // <- insert position
        ListElement {
            paramName: QT_TRANSLATE_NOOP("Math", "ResultVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }
    }

    Component.onCompleted: {
        parametersModel.insert(2,
                    {
                        "paramName": qsTranslate("Math", "Operation"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : qsTranslate("Math", "*"),
                                "desc"    : qsTranslate("Math", "Multiplication"),
                                "value"   : 0
                            },
                            {
                                "varName" : qsTranslate("Math", "/"),
                                "desc"    : qsTranslate("Math", "Devision"),
                                "value"   : 1
                            },
                            {
                                "varName" : qsTranslate("Math", "%"),
                                "desc"    : qsTranslate("Math", "Devision remainder"),
                                "value"   : 2
                            },
                            {
                                "varName" : qsTranslate("Math", "+"),
                                "desc"    : qsTranslate("Math", "Addition"),
                                "value"   : 3
                            },
                            {
                                "varName" : qsTranslate("Math", "-"),
                                "desc"    : qsTranslate("Math", "Subtraction"),
                                "value"   : 4
                            },
                            {
                                "varName" : qsTranslate("Math", "<<"),
                                "desc"    : qsTranslate("Math", "Left shift"),
                                "value"   : 5
                            },
                            {
                                "varName" : qsTranslate("Math", ">>"),
                                "desc"    : qsTranslate("Math", "Right shift"),
                                "value"   : 6
                            },
                            {
                                "varName" : qsTranslate("Math", "&"),
                                "desc"    : qsTranslate("Math", "Bit AND"),
                                "value"   : 7
                            },
                            {
                                "varName" : qsTranslate("Math", "^"),
                                "desc"    : qsTranslate("Math", "Exclusive OR"),
                                "value"   : 8
                            },
                            {
                                "varName" : qsTranslate("Math", "|"),
                                "desc"    : qsTranslate("Math", "Bit OR"),
                                "value"   : 9
                            },
                            {
                                "varName" : qsTranslate("Math", "&&"),
                                "desc"    : qsTranslate("Math", "Logical AND"),
                                "value"   : 10
                            },
                            {
                                "varName" : qsTranslate("Math", "||"),
                                "desc"    : qsTranslate("Math", "Logical OR"),
                                "value"   : 11
                            }]
                    });
    }

    function setTitle() {
        var leftStr  = parametersModel.get(0).varName
        var rightStr = parametersModel.get(1).varName
        var opStr    = parametersModel.get(2).varName
        var resStr   = parametersModel.get(3).varName

        if (leftStr.length === 0)
            leftStr = qsTr("???")

        if (rightStr.length === 0)
            rightStr = qsTr("???")

        if (resStr.length === 0)
            resStr = qsTr("???")

        actionTitle = qsTr("%1 = %2 %3 %4")
                .arg(resStr).arg(leftStr).arg(opStr).arg(rightStr)
    }
}
