import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_FuelTarFilter"

    // unique for every action
    actionId: 0x04
    actionName: QT_TRANSLATE_NOOP("FuelTarFilter", "FuelTarFilter")
    actionTitle: baseTitle
    actionToolTip: qsTr("Applies table to top input value of FLS. Based on bottom input value of temperature");
    actionOutputCount: 1

    dialogType: "fuel_tar_table_filter"
    parameterDialogSource: 'FuelTarFilterDialog.qml'
    nonPermanentParamType: "int"
    nonPermanentVarCategory: "const"

    property string baseTitle: qsTr("FuelTarFilter"); //"\n       Fuel Type\n\n                                       FuelTarFilter\n\n       Temperature");

    actionType: "action"
    view_type: view_types.two_inputs_filter
    origin_param_count: 6

    inputs_lables: [qsTr("fuel sensor"), qsTr("temperature")];

    parametersModel: ListModel {
        id: core_model
        onDataChanged: {
            sendResultToNext();
        }

        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Choose Param 1")
            paramType: "int" // Тип определяет доступные переменные для выбора
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Choose Param 2")
            paramType: "int" // Тип определяет доступные переменные для выбора
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        // Место зарезервировано для типа топлива
        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Fuel type")
            paramType: "categoryList" // Тип определяет доступные переменные для выбора
            varCategory: "categoryList"
            varName: ""
            varBaseCategory: ""
            isEditable: false
        }

        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "temperature")
            paramType: "int" // Тип определяет доступные переменные для выбора
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        // Место для типа интерполяции
        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Interp Type")
            paramType: "int" // Тип определяет доступные переменные для выбора
            varCategory: "const"
            varName: "1" // Linear
            varBaseCategory: "const"
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Result Param")
            paramType: "int" // Тип определяет доступные переменные для выбора
            varCategory: "global"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    Component.onCompleted: {
        core_model.set(2,
                    {
                        "paramName": qsTranslate("FuelTarFilter", "Fuel Type"),
                        "paramType": categoryList,
                        "varCategory": categoryList,                        
                        "varName": "",
                        "varBaseCategory": "",
                        "isEditable": false,
                        "paramList" :
                                        [{
                                          "varName" : qsTranslate("FuelTarFilter", "Gasoline (750 kg/m3)"),
                                          "desc"    : qsTranslate("FuelTarFilter", "Gasoline"),
                                          "value"   : 750
                                        },
                                        {
                                          "varName" : qsTranslate("FuelTarFilter", "Diesel winter (830 kg/m3)"),
                                          "desc"    : qsTranslate("FuelTarFilter", "Octane number 92"),
                                          "value"   : 830
                                        },
                                        {
                                          "varName" : qsTranslate("FuelTarFilter", "Diesel summer (860 kg/m3)"),
                                          "desc"    : qsTranslate("FuelTarFilter", "Octane number 95"),
                                          "value"   : 860
                                        }]
                    });
    }
}
