import QtQuick 2.0

ListModel {
    id: generalActionsModel
    objectName: "generalActionsModel"

    default property list<ListModel> devModels

    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Diagnostic message")
        image: "images/icon_rect_blue.svg"
        source: 'actions/DiagMessage.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Run command")
        image: "images/icon_rect_blue.svg"
        source: 'actions/RunCommand.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Delay")
        image: "images/icon_rect_blue.svg"
        source: 'actions/Delay.qml'
    }   
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Save point")
        image: "images/icon_rect_blue.svg"
        source: 'actions/SavePoint.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Script")
        image: "images/icon_rect_blue.svg"
        source: 'actions/Script.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Send SMS")
        image: "images/icon_rect_blue.svg"
        source: 'actions/SendSMS.qml'
    }
    ListElement{
        name: QT_TRANSLATE_NOOP("generalActionsModel", "Send answer")
        image: "images/icon_rect_blue.svg"
        source: 'actions/SendAnswer.qml'
    }

    onDevModelsChanged:
    {
        if (!DEVELOPER_MODE) return;
        var i = devModels.length - 1;
        if (i < 0) return;

        for (var j = 0; j < devModels[i].count; j++)
            generalActionsModel.append(devModels[i].get(j));
     }
}
