import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_TarFilter"

    // unique for every action
    actionId: 0x03
    actionName: QT_TRANSLATE_NOOP("TarFilter", "TarFilter")
    actionTitle: baseTitle
    actionToolTip: qsTr("Applies table to the input value");
    actionOutputCount: 1

    dialogType: "tar_table_filter"
    parameterDialogSource: 'TarTableDialog.qml'

    property string baseTitle: qsTr("TarFilter")
    origin_param_count: 3

    actionType: "action"
    view_type: view_types.one_input_filter

    parametersModel: ListModel {
        id: core_model
        onDataChanged: {
            sendResultToNext();
        }

        ListElement{
            paramName: QT_TRANSLATE_NOOP("TarFilter", "Choose Param")
            paramType: "int";
            varCategory: ".*"; // Категория определяет доступные переменные для выбора
            varName: "";
            varBaseCategory: ""
            isEditable: true;
        }

        // Место для типа интерполяции
        ListElement{
            paramName: QT_TRANSLATE_NOOP("FuelTarFilter", "Interp Type")
            paramType: "int";
            varCategory: "const"; // Категория определяет доступные переменные для выбора
            varName: "1"; // Linear
            varBaseCategory: "const";
            isEditable: true;
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("TarFilter", "Result Param")
            paramType: "int"
            varCategory: "global" // Категория определяет доступные переменные для выбора
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }
}
