import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SemaphoreTake"

    // unique for every action
    actionId: 0x26
    actionName: qsTr("SemaphoreTake")
    actionTitle: qsTr("Take semaphore:\n???")
    actionToolTip: qsTr("Take semaphore")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: qsTr("Index (0..4)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Timeout, ms (0..60000)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var index = parametersModel.get(0).varName
        var timeout = parametersModel.get(1).varName
        if (index.length === 0)
            index = "???"
        if (timeout.length === 0)
            timeout = "???"
        actionTitle = qsTr("Take semaphore: \nIndex: %1\nTimeout: %2 ms\n").arg(index).arg(timeout)
    }
}
