import QtQuick 2.4
import QtQuick.Controls 1.3
import QtQuick.Layouts 1.1
import "auxiliary.js" as Code

Rectangle {
    id: varNameItem
    objectName: "varNameItem"
    
    // external interface
    property ListModel paramModel: null
    property int paramIndex: -1

    // internal use
    property string paramName: ""       // used in varNameDialog title
    property string paramType: ""
    property string varCategory:  ""
    property string varBaseCategory:  ""            // базовая категория переменной (а не фильтр в случае с varCategory)
    property string varName: ""                     // already accepted varName
    property string varAllowance: ""                // Для определения можем мы такую переменную в фильтрах показывать или нет.
    property var inputValidator: /.*/               // Проверка вводимых значений (по умолчанию можно все)

    property alias localVarName: varNameInput.text  // current user choise
    property string localVarBaseCategory: ""              // current category
    property var varNameDialog: null                // application modal window pointer


    property alias comboBox: varNameList // для здания фокуса из события не pressed
    property bool is_text_allowed: false

    function updateItem(paramIndex, reason) {
        console.debug(objectName, "updateItem():", paramIndex, reason);
        // update local properties
        if ((paramModel !== null)
                && (-1 < paramIndex) && (paramIndex < paramModel.count))
        {
            paramName   = paramModel.get(paramIndex).paramName;
            paramType   = paramModel.get(paramIndex).paramType;
            varCategory = paramModel.get(paramIndex).varCategory;
            varName     = paramModel.get(paramIndex).varName;
            varBaseCategory = paramModel.get(paramIndex).varBaseCategory;
            var allowance = paramModel.get(paramIndex).varAllowance;
            if (undefined === allowance){
                varAllowance = "";
            } else {
                varAllowance= allowance;
            }
        }
        else {
            paramName   = "";
            paramType   = "";
            varCategory = "";
            varName     = "";
            varBaseCategory = "";
            varAllowance= "";
        }

        // update visual items
        if (paramType === categoryList) {
            varNameList.visible = true;
            varNameList.model = paramModel.get(paramIndex).paramList;
        }
        else {
            varNameList.visible = false;
            varNameList.model = null
            varNameList.currentIndex = -1;
        }
        updateVisualItems(varName, varCategory);

        console.debug(objectName, "updateItem():", paramModel, paramIndex,
                      paramName, paramType, varCategory, varName, varAllowance);
    }

    function updateVisualItems(varName, varCategory) {
        if ((localVarName !== varName) || (localVarBaseCategory !== varCategory)){
            localVarName = varName;
            localVarBaseCategory = varCategory;
            if ((varNameList.model !== null) && (0 < varName.length))
            {
                varNameList.currentIndex = varNameList.find(varName);
                if (is_text_allowed)
                    varNameList.editText  = varName;
            }
            else
                varNameList.currentIndex = -1;
        }
    }

    // accept varName from ComboBox or VarNameDialog
    function acceptVarName(varName, varCategory) {
        console.log("acceptVarName: old:", varNameItem.varName, varNameItem.varBaseCategory, "new:", varName, varCategory);
        // set varName of paramModel
        if ((varNameItem.varName !== varName) || (varNameItem.varBaseCategory !== varCategory)) {
            varNameItem.varName = varName;
            varNameItem.varBaseCategory = varCategory;
            varNameItem.paramModel.set(paramIndex, {"varName": varName});
            varNameItem.paramModel.set(paramIndex, {"varBaseCategory": varCategory});
        }
        console.log("updateVisualItems");
        updateVisualItems(varName, varCategory);

        console.debug(objectName, "acceptVarName():", paramName,
                      varName, varNameList.currentIndex);
    }

    radius: Math.round(2 * kDPI)
    border.color: (0 < localVarName.length)
                  ? ((localVarName !== varName) || (varNameList.pressed)) ? colorModified : colorOk
                  : colorError
    border.width: (varNameInput.activeFocus || varNameList.activeFocus) ? 2 : 1

    onParamModelChanged: updateItem(paramIndex, "paramModelChanged");
    onParamIndexChanged: updateItem(paramIndex, "paramIndexChanged");

    Component.onCompleted: {
        console.debug(objectName, "onCompleted:", paramModel, paramIndex);
    }

    ComboBox {      // for list-type parameter
        id: varNameList

        anchors.fill: parent
        visible : paramType === categoryList
        activeFocusOnPress: true       
        editable: is_text_allowed
        textRole: "varName"

        onActivated: {
            console.debug("onActivated", paramIndex, "index: ", index, "currentIndex: ", currentIndex);
            var category = (paramType === typeInt) ? categoryGlobal : categoryConst;
            acceptVarName(textAt(/*currentIndex*/index), category);
        }

        onAccepted: {
//            console.debug("onAccepted", paramIndex, "index: ", index, "currentIndex: ", currentIndex);
            var category = (paramType === typeInt) ? categoryGlobal : categoryConst;
            acceptVarName(editText, category);
        }

        onCountChanged: {
            currentIndex = find(varName);
        }

    }
    Item {
        id: varNameInputItem

        anchors.fill: parent
        visible: paramType !== categoryList

        TextInput {
            id: varNameInput
            objectName: "varNameInput"

            function acceptText() {
                if (length === 0)
                    return;

                if (text === varName)
                    return;

                var category;

                if((paramType !== typeString) && (paramType !== typeScript))
                    category = categoryGlobal;// может быть int, int|string - то приоритет int
                else
                    category = categoryConst;

                if (varsModel.getVarId(text, category) === -1) {
                    varsModel.addVar(category,
                                     paramType,
                                     "Algorithms", text /*name*/,
                                     ""/*description*/, text /*value*/);
                }
                acceptVarName(text, category);
            }

            anchors.fill: parent
            anchors.leftMargin: 4
            anchors.rightMargin: 4
            verticalAlignment: Text.AlignVCenter
            selectByMouse: true
            clip: true
            text: "varNameInput"
            validator: RegExpValidator { regExp: inputValidator }

            onActiveFocusChanged: {
                console.debug(objectName, "onActiveFocusChanged:");
                if (activeFocus === false) {
                    // Уберём маркеры направления ввода текста
                    text = text.replace("\u202C", "")
                    text = text.replace("\u202D", "")
                    acceptText();
                    paramModel.setProperty(paramIndex, "isActive", false);
                } else {
                    console.debug(objectName, "set index: " + Number(paramIndex).toString());
                    paramModel.setProperty(paramIndex, "isActive", true);
                }
            }
            Keys.onEscapePressed: {
                console.debug(objectName, "onEscapePressed:");
                focus = false;
                event.accepted = false; // propagate pressing Esc to parent
            }
            onAccepted: {       // process ENTER
                console.debug(objectName, "onAccepted:");
                focus = false;
            }
        }
        Button {
            id: varNameDialogButton
            objectName: "varNameDialogButton"

            anchors.right: parent.right
            anchors.rightMargin: 1
            anchors.verticalCenter: parent.verticalCenter
            width: height
            height: parent.height-2
            text: "..."

            onClicked: {
                varNameInput.acceptText();
                varNameDialog =
                        Code.loadAndCreate("VarNameDialog.qml",
                                           varNameItem);
                if (diagramItem !== null){
                    varNameDialog.title =
                            qsTr("Choose variable for parameter %1")
                    .arg(qsTranslate(diagramItem.actionName,
                                     paramName));
                } else {
                    varNameDialog.title = "Can Data"
                }

                varNameDialog.varName = varNameItem.varName;
                varNameDialog.varType = varNameItem.paramType;
                varNameDialog.varCategory = varNameItem.varCategory;
                varNameDialog.varBaseCategory = varNameItem.varBaseCategory;
                varNameDialog.varAllowance = varNameItem.varAllowance;
                varNameDialog.setLocalVarName(varNameItem.varName, varNameItem.varBaseCategory);
                varNameDialog.visible = true;
                varNameDialog.accepted.connect(acceptVarName);
            }
        }
    }
}
