import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SendSMS"

    // unique for every action
    actionId: 0x07
    actionName: QT_TRANSLATE_NOOP("SendSMS", "SendSMS")
    actionTitle: qsTr("Send SMS:\n???")
    actionToolTip: qsTr("Send SMS")

    permanentParametersCount: 2
    nonPermanentParameterName: QT_TRANSLATE_NOOP("DiagMessage", "Argument")
    nonPermanentParamType: "int|string"
    nonPermanentVarCategory: ".*"

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SendSMS", "Phone number")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("SendSMS", "SMS message")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }

    function setTitle() {
        var phoneStr   = parametersModel.get(0).varName
        var messageStr = parametersModel.get(1).varName

        if (phoneStr.length === 0)
            phoneStr = qsTr("???")
        if (messageStr.length === 0)
            messageStr = qsTr("???")

        var str = qsTr("Send SMS:\nPhone number: %1\nSMS message: %2")
                .arg(phoneStr).arg(messageStr);
        for (var i = permanentParametersCount; i < parametersModel.count; ++i) {
            str += "\n" + qsTranslate("DiagMessage", nonPermanentParameterName)
                + ": " + parametersModel.get(i).varName;
        }
        actionTitle = str;
    }
}
