import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_HighPassFilter"

    // unique for every action
    actionId: 0x02
    actionName: QT_TRANSLATE_NOOP("HighPassFilter", "HighPassFilter")
    actionTitle: baseTitle
    actionToolTip: qsTr("Applies cut off frequency to the input value");
    actionOutputCount: 1

    property string baseTitle: qsTr("HighPassFilter")

    parameterDialogSource: "SimpleFilterDialog.qml"

    actionType: "action"
    view_type: view_types.one_input_filter
    need_check_tar_table: false

    parametersModel: ListModel {
        id: core_model

        onDataChanged: {
            sendResultToNext();
        }

        Component.onCompleted: {
            var res_var_name = Code.generateVarName(diagramAction);
            core_model.set(2, {"varName":res_var_name});
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("HighPassFilter", "Parameter")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName:  qsTr("Cut Off Frequency")
            paramType: "int"
            varCategory: "const"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("HighPassFilter", "Result")
            paramType: "int"
            varCategory: "localConst"
            varName: ""
            varBaseCategory: ""
            isEditable: true
        }
    }
}
