import QtQuick 2.2
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.2

Button {
    id: testButton
    objectName: "testButton"

    implicitWidth: Math.round(30 * kDPI)
    implicitHeight: Math.round(28 * kDPI)
    property string imageSource: ""

    style: ButtonStyle {
        background:  Item {
            anchors.fill: parent
            Rectangle {
                id: shadowRect
                x: control.pressed ? 0 : 1
                y: control.pressed ? 0 : 1
                implicitWidth:  parent.width-1
                implicitHeight: parent.height-1
                radius: Math.round(10 * kDPI)
                color: colorToolbarButtonShadow
            }
            Rectangle {
                id: foreRect
                x: control.pressed ? 1 : 0
                y: control.pressed ? 1 : 0
                implicitWidth:  parent.width-1
                implicitHeight: parent.height-1
                radius: Math.round(10 * kDPI)
                color: {
                    if (!control.enabled)
                        return colorToolbarButtonDisabled;
                    else if (control.hovered)
                        return colorToolbarButtonHovered;
                    else
                        return colorToolbarButton;
                }
            }
        }
        label: Image {
            id: name
            anchors.fill: parent
            source: imageSource
            x: control.pressed ? 1 : 0
            y: control.pressed ? 1 : 0
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
        }
    }
}
