import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1

FocusScope {

    id: actionsGroupToolBar
    property var subgroupBlockSize: Math.round(30 * kDPI)
    property var subgroupCreatedCount: 0

    height: columnActionsGroupToolBar.height

    //--------------------------------------------------------------------------------
    property list<ListModel> groupModels: [
        GeneralActionsModel{},          //groupIndex: 0
        WorkingWithVariablesModel{},    //groupIndex: 1
        CANBusModel{},                  //groupIndex: 2
        InsOutsModel{},                 //groupIndex: 3
        PeripheryModel{},               //groupIndex: 4
        DataArraysModel{},              //groupIndex: 5
        ModuleManagementModel{}         //groupIndex: 6
    ]

    ListModel {
        id: actionsGroupModel
        objectName: "actionsGroupModel"

        ListElement{
            groupName: qsTr("General actions")
            groupIndex: 0
        }
        ListElement{
            groupName: qsTr("Working with variables")
            groupIndex: 1
        }
        ListElement{
            groupName: qsTr("CAN bus")
            groupIndex: 2
        }
        ListElement{
            groupName: qsTr("Ins/Outs")
            groupIndex: 3
        }
        ListElement{
            groupName: qsTr("Periphery")
            groupIndex: 4
        }
        ListElement{
            groupName: qsTr("Data arrays")
            groupIndex: 5
        }
        ListElement{
            groupName: qsTr("Modules management")
            groupIndex: 6
        }
    }
    //--------------------------------------------------------------------------------


    Column {
        id: columnActionsGroupToolBar

        width: parent.width

        Rectangle {
            anchors.left: parent.left
            anchors.right: parent.right
            height: panelCaptionHeight
            color: colorGroup
            border.width: 1
            border.color: colorScrollBorder

            ActionToolButton {
                id: panelButton
                text: qsTr("Actions")
                anchors.fill: parent
            }            
        }

        ListView {
            id: listViewGroup
            objectName: "listViewGroup"
            anchors.left: parent.left
            anchors.right: parent.right
            model: actionsGroupModel
            height: subgroupBlockSize * count
            interactive: false

            delegate: ActionsSubgroupToolBar{
                groupName: model.groupName
                groupModel: groupModels[model.groupIndex]
            }

            Behavior on height {
                NumberAnimation {
                    easing.type: Easing.OutQuad
                }
            }
        }
    }
}


