import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetGNSS"

    // unique for every action
    actionId: 0x25
    actionName: QT_TRANSLATE_NOOP("SetGNSS", "SetGNSS")
    actionTitle: qsTr("Set geo data:\n???")
    actionToolTip: qsTr("Set geo data")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: qsTr("Latitude (10⁻⁶ deg)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Longitude (10⁻⁶ deg)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Datetime (sec since 01.01.2000)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Altitude (m)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Speed (km/h)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Angle (0.1 deg)")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

    }

    function setTitle() {
        var lat = parametersModel.get(0).varName
        var lon = parametersModel.get(1).varName
        var date = parametersModel.get(2).varName
        var alt = parametersModel.get(3).varName
        var speed = parametersModel.get(4).varName
        var course = parametersModel.get(5).varName
        if (lat.length === 0)
            lat = "???"
        if (lon.length === 0)
            lon = "???"
        if (date.length === 0)
            date = "???"
        if (alt.length === 0)
            alt = "???"
        if (speed.length === 0)
            speed = "???"
        if (course.length === 0)
            course = "???"
        var coords = qsTr("Latitude: %1\n Longitude: %2").arg(lat).arg(lon)
        var other_params = qsTr("Datetime: %1 Altitude: %2 Speed: %3 Angle: %4").arg(date).arg(alt).arg(speed).arg(course)
        actionTitle = qsTr("Set geo data:\n %1\n %2\n").arg(coords).arg(other_params)
    }
}
