import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_RunCommand"

    // unique for every action
    actionId: 0x21
    actionName: QT_TRANSLATE_NOOP("RunCommand", "RunCommand")
    actionTitle: qsTr("Run command:\n???")
    actionToolTip: qsTr("Run command")

    parametersModel: ListModel {

        onDataChanged:  setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("RunCommand", "Command")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var messageStr = parametersModel.get(0).varName

        if (messageStr.length === 0)
            messageStr = qsTr("???")

        actionTitle = qsTr("Run command:\n\"%1\"").arg(messageStr);
    }
}
