import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_ReceiveCanMessage"

    // unique for every action
    actionId: 0x1C
    actionName: QT_TRANSLATE_NOOP("ReceiveCanMessage", "ReceiveCanMessage")
    actionTitle: qsTr("Receive CAN Message:\n\"\"");
    actionToolTip: qsTr("Choose branch according to receive result")
    actionOutputCount: 2

    parameterDialogSource: 'ReceiveCanMessageDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("ReceiveCanMessage", "ID")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ReceiveCanMessage", "Data 1")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ReceiveCanMessage", "Data 2")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ReceiveCanMessage", "Data byte length")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
	
        Component.onCompleted: {					
            parametersModel.append(
                        {
                            "paramName": qsTranslate("ReceiveCanMessage", "Interface"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "CAN0",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : "CAN0",
                                    "value"   : 0
                                },
                                {
                                    "varName" : "CAN1",
                                    "value"   : 1
                                }]
                        });
			setTitle()
        }	

		function setTitle() {
			var _id  = parametersModel.get(0).varName
			var _data_1 = parametersModel.get(1).varName
			var _data_2 = parametersModel.get(2).varName
			var _data_len = parametersModel.get(3).varName
			var canIndex = parametersModel.get(4).varName		

			if (_id.length === 0)
				_id = qsTr("???")

			if (_data_1.length === 0)
				_data_1 = qsTr("???")

			if (_data_2.length === 0)
				_data_2 = qsTr("???")

			if (_data_len.length === 0)
				_data_len = qsTr("???")

			actionTitle = qsTr("Recieve %1 message:\n  %2, %3, %4, %5")
					.arg(canIndex).arg(_id).arg(_data_1).arg(_data_2).arg(_data_len)
		}
	}
}
