import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_CanMessageParsing"

    // unique for every action
    actionId: 0x1E
    actionName: QT_TRANSLATE_NOOP("ParseCanMessage", "ParseCanMessage")
    actionTitle: qsTr("Parsing:\n\"\"")
    actionToolTip: qsTr("Can Message Parsing")

    parameterDialogSource: 'CanMessageParsingDialog.qml'

    dialogType: "can_parser"

    parametersModel: ListModel {
        id: core_model

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("ParseCanMessage", "Data 1")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            isVisible: false
            isActive: false
            value: 0
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ParseCanMessage", "Data 2")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            isVisible: false
            isActive: false
            value: 0
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ParseCanMessage", "store var 1");
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: "global"
            varName: ""
            isEditable: true
            isVisible: true
            isActive: true
            value: 0
        }

        function removeElement(index){
            core_model.remove(index, 4);
        }
        function addParameter() {
            console.debug(objectName, "footer.onClicked()")
            // Добавляем параметр который отвечает за глобальную переменную
            // Но сначала получим индекс последнего элемента в хвост к которому будем его добавлять
            var param_count = core_model.count;
            var var_index = (core_model.count -2)/4 + 1;
            console.debug(objectName, "param count: %1\n  added index %2".arg(param_count).arg(var_index));
            parametersModel.insert(param_count++, {   "paramName": qsTranslate("ParseCanMessage", "store var %1".arg(var_index)),
                                       "paramType": "int",
                                       "varCategory": "global",
                                       "varName"  : "",
                                       "isEditable" : true,
                                       "isVisible" : true,
                                       "isActive" : false,
                                       "value": 0
                                   })
            // Добавляем еще 2 параметра. которые отвечают за диапазон битов в CAN сообщении
            parametersModel.insert(param_count++, {   "paramName": qsTranslate("end", "store end %1".arg(var_index)),
                                       "paramType": categoryCanIndex,
                                       "varCategory": categoryCanIndex,
                                       "varName": "0",
                                       "isEditable": false,
                                   })
            parametersModel.insert(param_count++, {   "paramName": qsTranslate("begin", "store begin %1".arg(var_index)),
                                       "paramType": categoryCanIndex,
                                       "varCategory": categoryCanIndex,
                                       "varName": "7",
                                       "isEditable": false,
                                   })

            parametersModel.insert(param_count++, {   "paramName": qsTranslate("endian", "store endian %1".arg(var_index)),
                                       "paramType": categoryCanIndex,
                                       "varCategory": categoryCanIndex,
                                       "varName": "0",
                                       "isEditable": false,
                                   })
        }
   }

    Component.onCompleted: {
        parametersModel.insert(3,
                    {
                        "paramName": qsTranslate("end", "store end 1"),
                        "paramType": categoryCanIndex,
                        "varCategory": categoryCanIndex,
                        "varName": "0",
                        "isEditable": false,
                     });
        parametersModel.insert(4,
                    {
                        "paramName": qsTranslate("begin", "store begin 1"),
                        "paramType": categoryCanIndex,
                        "varCategory": categoryCanIndex,
                        "varName": "7",
                        "isEditable": false,
                     });
        parametersModel.insert(5,
                    {
                        "paramName": qsTranslate("endian", "store endian 1"),
                        "paramType": categoryCanIndex,
                        "varCategory": categoryCanIndex,
                        "varName": "0",
                        "isEditable": false,
                     });
    }

    function setTitle() {
        var data_1 = parametersModel.get(0).varName
        var data_2 = parametersModel.get(1).varName

        if (data_1.length === 0)
            data_1 = qsTr("???")

        if (data_2.length === 0)
            data_2 = qsTr("???")

        var strArgs = "";
        var i;
        if ("" !== parametersModel.get(2).varName){
            for (i = 2; i < parametersModel.count; ++i) {
                if (undefined !== parametersModel.get(i + 1)) {
                    strArgs += "\n" + parametersModel.get(i).varName + ": " +
                               (Number(parametersModel.get(++i).varName) + 1) + ',' +
                               (Number(parametersModel.get(++i).varName) + 1) + ',' +
                               (Number(parametersModel.get(++i).varName) + 1);
                }
            }
        }
        actionTitle = qsTr("Parse CAN Message\n%1, %2%3").arg(data_1).arg(data_2).arg(strArgs)
    }
}
