import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_NullInput"

    // unique for every action
    actionId: 0x0B
    actionName: QT_TRANSLATE_NOOP("NullInput", "NullInput")
    actionTitle: qsTr("Null input:\n???")
    actionToolTip: qsTr("Null input value for pulse counter")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("NullInput", "Input number")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var inputStr = parametersModel.get(0).varName

        if (inputStr.length === 0)
            inputStr = qsTr("???")

        actionTitle = qsTr("Null input pulse counter %1").arg(inputStr)
    }
}
