import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableCANReception"

    // unique for every action
    actionId: 0x20
    actionName: QT_TRANSLATE_NOOP("EnableCANReception", "EnableCANReception")
    actionTitle: qsTr("Set CAN messages reception mode")
    actionToolTip: qsTr("Enable CAN messages reception")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableCANReception", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        Component.onCompleted: {					
            parametersModel.append(
                        {
                            "paramName": qsTranslate("EnableCANReception", "Interface"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "CAN0",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : "CAN0",
                                    "value"   : 0
                                },
                                {
                                    "varName" : "CAN1",
                                    "value"   : 1
                                }]
                        });
        }	
	
		function setTitle() {
			var enableStr = parametersModel.get(0).varName;
			var canIndex = parametersModel.get(1).varName;

			if (enableStr.length === 0)
				enableStr = qsTr("???")
			
			if (enableStr === "0")
				actionTitle = qsTr("Disable %1 messages reception").arg(canIndex);
			else if (enableStr === "1")
				actionTitle = qsTr("Enable %1 messages reception").arg(canIndex);
			else
				actionTitle = qsTr("%1 messages reception:\nEnable = %2").arg(canIndex).arg(enableStr);
		}
	}
}
