import QtQuick 2.0
import "lineItemCreation.js" as Code

Filter {
    id: diagramAction
    objectName: "diagramAction_DeltaFilter"

    // unique for every action
    actionId: 0x08
    actionName: QT_TRANSLATE_NOOP("DeltaFilter", "DeltaFilter")
    actionTitle: baseTitle
    actionOutputCount: 1

    property string baseTitle: qsTr("DeltaFilter")

    parameterDialogSource: "none.qml"

    actionType: "action"
    view_type: view_types.one_input_filter
    need_check_tar_table: false

    parametersModel: ListModel {
        id: core_model

        onDataChanged: {
            sendResultToNext();
        }

        Component.onCompleted: {
            var res_var_name = Code.generateVarName(diagramAction);
            core_model.set(2, {"varName":res_var_name});
            res_var_name = Code.generateVarName(diagramAction);
            core_model.set(1, {"varName":res_var_name});
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("DeltaFilter", "Parameter")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: qsTr("Previous value")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("DeltaFilter", "Result")
            paramType: "int"
            varCategory: "localConst"
            varName: ""
            isEditable: true
        }
    }
}
