import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_ChangeOutput"

    // unique for every action
    actionId: 0x06
    actionName: QT_TRANSLATE_NOOP("ChangeOutput", "ChangeOutput")
    actionTitle: qsTr("Change output:\n???")
    actionToolTip: qsTr("Change state of the specified output")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("ChangeOutput", "OutputNumber")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("ChangeOutput", "OutputState")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var outStr   = parametersModel.get(0).varName
        var stateStr = parametersModel.get(1).varName

        if (outStr.length === 0)
            outStr = qsTr("???")

        if (stateStr.length === 0)
            stateStr = qsTr("???")

        actionTitle = qsTr("Output %1 = %2").arg(outStr).arg(stateStr)
    }
}
