import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_AddCanFilter"

    // unique for every action
    actionId: 0x1B
    actionName: QT_TRANSLATE_NOOP("AddCanFilter", "AddCanFilter")
    actionTitle: qsTr("Filter:\n\"\"")
    actionToolTip: qsTr("Add Can Filter")

    parameterDialogSource: 'AddCanFilterDialog.qml'

    parametersModel: ListModel {
        id: core_model

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("AddCanFilter", "Identifier")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            value: 0
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("AddCanFilter", "Mask")
            paramType: "int" // Если выставить такой тип, то переменная будет отображаться в списке глобальных переменных.
            varCategory: ".*"
            varName: ""
            isEditable: true
            value: 0
        } 
  
        Component.onCompleted: {
            parametersModel.append(
                        {
                            "paramName": qsTranslate("AddCanFilter", "Identifier Bits\n Length"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTranslate("AddCanFilter", "11-bits (CAN 2.0 A)"),
                                    "desc"    : qsTranslate("AddCanFilter", "11-bits "),
                                    "value"   : 0 // Standard Value
                                },				
								{
                                    "varName" : qsTranslate("AddCanFilter", "29-bits (CAN 2.0 B)"),
                                    "desc"    : qsTranslate("AddCanFilter", "29-bits"),
                                    "value"   : 1 // Extended Value
                                }]
                        });

            parametersModel.append(
                        {
                            "paramName": qsTranslate("AddCanFilter", "Interface"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "CAN0",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : "CAN0",
                                    "value"   : 0
                                },
                                {
                                    "varName" : "CAN1",
                                    "value"   : 1
                                }]
                        });
			setTitle()
        }   

		function setTitle() {
			var data_1 = parametersModel.get(0).varName
			var data_2 = parametersModel.get(1).varName
			var data_3 = parametersModel.get(2).varName
			var data_4 = parametersModel.get(3).varName
			
			if (data_1.length === 0)
				data_1 = qsTr("???")

			if (data_2.length === 0)
				data_2 = qsTr("???")

			if (data_3.length === 0)
				data_3 = qsTr("???")

			actionTitle = qsTr("%1\nIdentifier: %2\n Mask: %3\n Identifier Bits Length: %4").arg(data_4).arg(data_1).arg(data_2).arg(data_3)
		}
	}
}
