import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

Rectangle {
    id: baseParameterDialog
    objectName: "baseParameterDialog"

    property var diagramItem: null
    property alias parameterItem: parameterItem
    property Component parameterView: Rectangle {
        id: parameterView
        color: "yellow";
        border { width: 1; color: "red" }
    }
    property ListModel parametersModel: ListModel {}

    property string addParamButtonText: ""

    property real centerPointX: 0.0
    property real centerPointY: 0.0
    property real scaleFactorX: 0.0
    property real scaleFactorY: 0.0

    property alias dialogTitle: dialogTitleText.text

    width: Math.round(300 * kDPI)
    height: Math.round(160 * kDPI)
    radius: Math.round(10 * kDPI)
    z: zParameterDialog
    color: colorDialogBackground
    border.width: regularThickness
    border.color: colorDialogBorder
    focus: true
    visible: false

    Drag.active: dragMouseArea.drag.active
    Drag.hotSpot.x: width / 2
    Drag.hotSpot.y: height / 2

    signal itemIsAboutToDestroy(Item item)

    function dump() {
        console.debug("---- dump start:", objectName);
        console.debug(dialogTitle);
        var i;
        console.debug("parametersModel:", parametersModel);
        for (i = 0; i < parametersModel.count; ++i)
            console.debug(parametersModel.get(i).paramName,
                          parametersModel.get(i).paramType,
                          parametersModel.get(i).varName);
        console.debug("---- dump finish:", objectName);
        scriptGenerator.scriptModifiedFromQML();
    }

    function showItem(item) {
        console.debug(arguments.callee.name, item)
        diagramItem = item
        parametersModel = item.parametersModel;
        dialogTitle = qsTranslate(item.actionName, item.actionName)
        addParamButtonText = qsTr('Add "%1"')
                .arg(qsTranslate(diagramItem.actionName,
                                 diagramItem.nonPermanentParameterName))

        dump();

        recalculateParamsViewSize();

        // center dialog to item
        var itemCenter = diagramContainer.mapFromItem(item, item.width/2, item.height/2);
        centerPointX = itemCenter.x;
        centerPointY = itemCenter.y;

        // set size to item and show,...
        scaleFactorX = diagramContainer.diagramField.itemWidth / width;
        scaleFactorY = diagramContainer.diagramField.itemHeight / height;
        visible = true;
        // ...than animate to normal size
        scaleFactorX = 1.0;
        scaleFactorY = 1.0;
    }

    function selectionChanged(item, mouseEvent, itemWasSelected) {
        console.debug(objectName, "selectionChanged()", item)
        if (item === baseParameterDialog) {
            return;
        }

        destroyDialog(Qt.MouseFocusReason);
    }

    function destroyDialog(focusReason) {
        forceActiveFocus(focusReason)  // steal focus from delegates to accept their changes
        if (parametersModel) {
            var i, element
            // remove empty _temporary_ elements
            if (diagramItem.permanentParametersCount) {
                for (i = parametersModel.count-1; diagramItem.permanentParametersCount <= i; --i) {
                    element = parametersModel.get(i);
                    if (element.varName.length === 0)
                        parametersModel.remove(i);
                }
            }

            // parametersModel debug output
            console.debug(" ", dialogTitle, ":")
            for (i = 0; i < parametersModel.count; ++i) {
                element = parametersModel.get(i);
                console.debug(" ", element.paramName, element.varName);
            }
        }
//        visible = false
        itemIsAboutToDestroy(baseParameterDialog);

        baseParameterDialog.itemIsAboutToDestroy.disconnect(diagramField.itemIsAboutToDestroy)
        diagramField.selectionChanged.disconnect(baseParameterDialog.selectionChanged)
        baseParameterDialog.destroy();
    }

    Component.onCompleted: {
        baseParameterDialog.itemIsAboutToDestroy.connect(diagramField.itemIsAboutToDestroy)
        diagramField.selectionChanged.connect(baseParameterDialog.selectionChanged)
        forceActiveFocus();
        console.debug(objectName, "comleted")
    }
    Component.onDestruction: {
        console.debug(objectName, "destructed")
    }

    Keys.onEscapePressed: {
        console.debug(objectName, "onEscapePressed:");
        destroyDialog(Qt.ShortcutFocusReason)
    }
    Keys.onEnterPressed: {
        console.debug(objectName, "onEnterPressed:");
        destroyDialog(Qt.ShortcutFocusReason)
    }
    Keys.onReturnPressed: {
        console.debug(objectName, "onReturnPressed:");
        destroyDialog(Qt.ShortcutFocusReason)
    }

    MouseArea {
        id: dragMouseArea
        objectName: "dragMouseArea"

        anchors.fill: parent
        drag.target: parent
        acceptedButtons: (Qt.LeftButton | Qt.RightButton)
    }

    RowLayout {
        id: titleLayout
        objectName: "titleLayout"

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        height: titleHeight
        anchors.margins: parameterItemMargins

        Text {
            id: dialogTitleText

            Layout.fillWidth: true
            Layout.fillHeight: true
            verticalAlignment: Text.AlignVCenter
            font.bold: true
        }

        Image {
            id: closeRect

            width: Math.round(18 * kDPI)
            height: Math.round(18 * kDPI)
            source: "images/icon_close.svg"
            sourceSize.width: Math.round(18 * kDPI)
            sourceSize.height: Math.round(18 * kDPI)
            smooth: false

            MouseArea {
                id: closeRectArea
                objectName: "closeRectArea"
                anchors.fill: parent
                onClicked: {
                    console.debug("parametersDialog. Close clicked")
                    destroyDialog(Qt.MouseFocusReason)
                }
            }
        }
    }

    Item {
        id: parameterItem
        objectName: "parameterItem"

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: titleLayout.bottom
        anchors.bottom: parent.bottom
        anchors.margins: parameterItemMargins

        Loader {
            anchors.fill: parent
            sourceComponent: parameterView
        }
    }

    transform: [
        Scale {
            origin.x: width/2
            origin.y: height/2
            xScale: scaleFactorX
            yScale: scaleFactorY
        },
        Translate {
            x: centerPointX - width/2
            y: centerPointY - height/2
        }
    ]

    Behavior on scaleFactorX {
        enabled: visible
        NumberAnimation {
            easing.type: Easing.InOutQuad
        }
    }
    Behavior on scaleFactorY {
        enabled: visible
        NumberAnimation {
            easing.type: Easing.InOutQuad
        }
    }
}
