import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramEvent
    objectName: "diagramEvent_MakePhotoEvent"

    // unique for every event
    actionId: 0x06
    actionName: QT_TRANSLATE_NOOP("MakePhotoEvent", "MakePhotoEvent")
    actionTitle: qsTr("Should make photo:\n???")
    actionToolTip: qsTr("Should make photo")

    actionType: "systemEvent"
    actionColor: colorEvent
    actionTextColor: colorTextEvent

    parametersModel: ListModel {
        onDataChanged: setTitle()
    }

    Component.onCompleted: {
        parametersModel.append(
                    {
                        "paramName": qsTranslate("ShouldMakePhoto", "Port"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : "RS232[0]",
                                "desc"    : qsTranslate("ShouldMakePhoto", "RS232[0]"),
                                "value"   : 0
                            },
                            {
                                "varName" : "RS232[1]",
                                "desc"    : qsTranslate("ShouldMakePhoto", "RS232[1]"),
                                "value"   : 1
                            },
                            {
                                "varName" : "RS485",
                                "desc"    : qsTranslate("ShouldMakePhoto", "RS485"),
                                "value"   : 2
                            }]
                    });
    }

    function setTitle() {
        var portNumStr  = parametersModel.get(0).varName

        if (portNumStr.length === 0)
            portNumStr = qsTr("???")

        actionTitle = qsTr("Should make photo:\nPort: %1").arg(portNumStr)
    }
}
