import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_InitCan"

    // unique for every action
    actionId: 0x1F
    actionName: QT_TRANSLATE_NOOP("InitCan", "InitCan")
    actionTitle: qsTr("Initialize CAN\n speed: \"???\"");
    actionToolTip: qsTr("Initialize CAN interface")

    parametersModel: ListModel {

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("InitCan", "Speed")
            paramType: "int"
            varCategory: ".*"
            varName: ""
            isEditable: true
        }

        Component.onCompleted: {
            parametersModel.append(
                        {
                            "paramName": qsTranslate("InitCan", "Allow send CAN messages:"),
                            "paramType": categoryList,
                            "varCategory": categoryList,
                            "varName": "",
                            "isEditable": false,
                            "paramList" :
                                [{
                                    "varName" : qsTranslate("InitCan", "allow"),
                                    "desc"    : qsTranslate("InitCan", "allow send CAN message"),
                                    "value"   : 1 // Extended Value
                                },
                                {
                                    "varName" : qsTranslate("InitCan", "forbid"),
                                    "desc"    : qsTranslate("InitCan", "forbid send CAN message"),
                                    "value"   : 0 // Standard Value
                                }]
                        });
        }


        function setTitle() {
            var speed = parametersModel.get(0).varName
            if (speed.length === 0)
                speed = qsTr("???")

            var send = parametersModel.get(1).varName
            if (send.length === 0)
                send = qsTr("???")
            actionTitle = qsTr("Initialize CAN\n speed: \"%1\"\n %2 send CAN message").arg(speed).arg(send)
        }
    }
}
