import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_DisablePulseCounting"

    // unique for every action
    actionId: 0x0A
    actionName: QT_TRANSLATE_NOOP("DisablePulseCounting", "DisablePulseCounting")
    actionTitle: qsTr("Disable pulse counting:\n???")
    actionToolTip: qsTr("Disable counting of pulses for specified input")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("DisablePulseCounting", "Input number")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("DisablePulseCounting", "Disabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var inputStr    = parametersModel.get(0).varName;
        var disabledStr = parametersModel.get(1).varName;

        if (disabledStr === "1")
            actionTitle = qsTr("Disable pulse counting on input %1").arg(inputStr);
        else if (disabledStr === "0")
            actionTitle = qsTr("Enable pulse counting on input %1").arg(inputStr);
        else
            actionTitle = qsTr("Disable pulse counting:\nInput: %1\nDisabled: %2")
                    .arg(inputStr).arg(disabledStr)
    }
}
