import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Layouts 1.1
import com.galileosky.cppclasses 1.0

BaseParameterDialog {
    id: canMessageParametersDialog
    objectName: "canMessageParametersDialog"

    property int leftParamWidth: Math.round(100 * kDPI)
    property int textWidth: Math.round(85 * kDPI)

    width: leftParamWidth
           + textWidth
           + parameterItemSpacing * 1
           + parameterItemMargins * 2

    function recalculateParamsViewSize() {
        // Функция отвечающя за применение окончательного размера окна диалога
        // Если нужно поменять размер - данные нужно менять в ней.
        var l_height = titleHeight
                + parameterItemHeight*5
                + parameterItemSpacing*4

        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    parameterView: Item {
        id: parameterView

        ColumnLayout {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: parameterItemSpacing * 2

            Row {
                id: conditionLayout

                height: parameterItemHeight
                width: canMessageParametersDialog.width


                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTranslate("RecieveCanMessage", "ID");
                }

                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 0
                }
            }
            Row {
                height: parameterItemHeight
                width: canMessageParametersDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTranslate("RecieveCanMessage", "Data 1");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 1
                }
            }
            Row {
                height: parameterItemHeight
                width: canMessageParametersDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTranslate("RecieveCanMessage", "Data 2");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 2
                }
            }
            Row {
                height: parameterItemHeight
                width: canMessageParametersDialog.width
                Text{
                    height: parameterItemHeight
                    width: textWidth;
                    text: qsTranslate("RecieveCanMessage", "Data byte length");
                }
                VarNameItem {
                    width: leftParamWidth
                    height: parameterItemHeight
                    paramModel: parametersModel
                    paramIndex: 3
                }
            }
        }
    }
}
