import QtQuick 2.2
import QtQuick.Controls 1.3
import QtQuick.Layouts 1.1

BaseParameterDialog {
    id: parametersDialog
    objectName: "parametersDialog"

    property bool addParamButtonVisible: (diagramItem === null)
                                         ? false
                                         : (diagramItem.permanentParametersCount !== 0)

    readonly property int magicHeightAdjustment: Math.round(6 * kDPI)

    function recalculateParamsViewSize() {
        var l_height = titleHeight
                + parametersModel.count * parameterItemHeight
                + (parametersModel.count-1) * parameterItemSpacing
                + parameterItem.anchors.margins * 2
                + magicHeightAdjustment     // magic height adjustment
        if (addParamButtonVisible === true) {
            // add height to make addParamButton visible
            l_height += parameterItemHeight;
        }
        height = Math.max(l_height, diagramContainer.diagramField.itemHeight);
        console.debug(arguments.callee.name, objectName, width, height);
    }

    Component {
        id: parameterDelegate
        Item {
            id: parametersItem

            property int paramIndex: index
            property string paramName: ""

            width: parent.width
            height: parameterItemHeight

            Component.onCompleted: {
                paramName = qsTranslate(diagramItem.actionName, model.paramName);
            }

            RowLayout {
                anchors.fill: parent

                spacing: Math.round(2 * kDPI)

                Image {
                    id: deleteButton
                    width: imageHeight
                    height: imageHeight
                    anchors.verticalCenter: parent.verticalCenter
                    source: "images/icon_del.svg"
                    sourceSize.width: imageHeight
                    sourceSize.height: imageHeight
                    smooth: false
                    visible: diagramItem.permanentParametersCount
                                 ? diagramItem.permanentParametersCount <= index
                                 : false

                    MouseArea {
                        anchors.fill: parent

                        onClicked: {
                            console.debug("deleteButotn.onClicked:", index)
                            parametersModel.remove(index)
                        }
                    }
                }
                Text {
                    Layout.minimumWidth: Math.round(30 * kDPI)
                    Layout.fillHeight: true
                    verticalAlignment: Text.AlignVCenter
                    text: parametersItem.paramName
                }
                Item {
                    objectName: "spacer"
                    implicitWidth: Math.round(4 * kDPI)
                }

                VarNameItem {   // for others types
                    Layout.fillWidth: true
                    Layout.fillHeight: true
                    paramModel: parametersModel
                    paramIndex: parametersItem.paramIndex
                }
            }
        }
    }

    parameterView: Item {
        ListView {
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: addParamButton.top
            spacing: parameterItemSpacing
            clip: true
            interactive: false

            model: parametersModel    // using property alias parametersModel
            delegate: parameterDelegate

            onCountChanged: {
                recalculateParamsViewSize();
            }
        }
        Rectangle {
            id: addParamButton
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            height: addParamButtonVisible ? parameterItemHeight : 0
            radius: height/3
            color: "transparent"
            border.width: 1
            border.color: colorBorder
            visible: addParamButtonVisible

            Text {
                anchors.centerIn: parent
                text: addParamButtonText
            }

            MouseArea {
                anchors.fill: parent

                onClicked: {
                    console.debug(parametersDialog.objectName, "footer.onClicked()")
                    parametersModel.append({   "paramName": diagramItem.nonPermanentParameterName,
                                               "paramType": diagramItem.nonPermanentParamType,
                                               "varCategory": diagramItem.nonPermanentVarCategory,
                                               "varName"  : "",
                                               "isEditable" : true
                                           })
                }
            }
        }
    }
}
