import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SetInputValue"

    // unique for every action
    actionId: 0x0B
    actionName: QT_TRANSLATE_NOOP("SetInputValue", "SetInputValue")
    actionTitle: qsTr("Set input ??? value to ???")
    actionToolTip: qsTr("Set value for input")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SetInputValue", "Input number")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SetInputValue", "Value")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var inputStr = parametersModel.get(0).varName
        var valStr = parametersModel.get(1).varName

        if (inputStr.length === 0)
            inputStr = qsTr("???")

        if (valStr.length === 0)
            valStr = qsTr("???")	

        actionTitle = qsTr("Set input %1 value to %2").arg(inputStr).arg(valStr)
    }
}
