import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_SendAnswer"

    // unique for every action
    actionId: 0x0F
    actionName: QT_TRANSLATE_NOOP("SendAnswer", "SendAnswer")
    actionTitle: qsTr("Send answer:\n???")
    actionToolTip: qsTr("Send answer to data channel")

    permanentParametersCount: 1
    nonPermanentParameterName: QT_TRANSLATE_NOOP("SendAnswer", "Argument")
    nonPermanentParamType: "int|string"
    nonPermanentVarCategory: ".*"

    parametersModel: ListModel {

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("SendAnswer", "Answer")
            paramType: "string"
            varCategory: "(global|const|localConst)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var answerStr = parametersModel.get(0).varName

        if (answerStr.length === 0)
            answerStr = qsTr("???")

        var str = qsTr("Send answer:\n\"%1\"").arg(answerStr);
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            str += "\n" + qsTranslate("SendAnswer", nonPermanentParameterName)
                + ": " + parametersModel.get(i).varName;
        }
        actionTitle = str;
    }
}
