import QtQuick 2.0

Action {
    id: diagramAction
    objectName: "diagramAction_Script"

    // unique for every action
    actionId: 0x0D
    actionName: QT_TRANSLATE_NOOP("Script", "Script")
    actionTitle: qsTr("Script:\n???")
    actionToolTip: qsTr("Script")

    dialogType: "script"

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("Script", "Script name")
            paramType: "script"
            varCategory: "const"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var scriptName = parametersModel.get(0).varName
        if (scriptName.length)
            actionTitle = qsTr("Script:\n") + scriptName
        else
            actionTitle = qsTr("Script:\n???")
    }
}
