import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_RecieveCanMessage"

    // unique for every action
    actionId: 0x1C
    actionName: QT_TRANSLATE_NOOP("RecieveCanMessage", "RecieveCanMessage")
    actionTitle: qsTr("Recieve Can Message:\n\"\"");
    actionToolTip: qsTr("Choose branch according to recieve result")
    actionOutputCount: 2

    parameterDialogSource: 'RecieveCanMessageDialog.qml'

    parametersModel: ListModel {

        onDataChanged: setTitle()
        onCountChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("RecieveCanMessage", "ID")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("RecieveCanMessage", "Data 1")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("RecieveCanMessage", "Data 2")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("RecieveCanMessage", "Data byte length")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var _id  = parametersModel.get(0).varName
        var _data_1 = parametersModel.get(1).varName
        var _data_2 = parametersModel.get(2).varName
        var _data_len = parametersModel.get(3).varName

        if (_id.length === 0)
            _id = qsTr("???")

        if (_data_1.length === 0)
            _data_1 = qsTr("???")

        if (_data_2.length === 0)
            _data_2 = qsTr("???")

        if (_data_len.length === 0)
            _data_len = qsTr("???")

        actionTitle = qsTr("RecieveCanMessage:\n  %1, %2, %3, %4")
                .arg(_id).arg(_data_1).arg(_data_2).arg(_data_len)
        console.debug("title changed");
    }
}
