import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramEvent
    objectName: "diagramEvent_IncomingCall"

    // unique for every event
    actionId: 0x02
    actionName: QT_TRANSLATE_NOOP("IncomingCall", "IncomingCall")
    actionTitle: qsTr("IncomingCall:\n???")
    actionToolTip: qsTr("Incoming call has been registered")

    actionType: "systemEvent"
    actionColor: colorEvent
    actionTextColor: colorTextEvent

    permanentParametersCount: 1
    nonPermanentParameterName: QT_TRANSLATE_NOOP("IncomingCall", "Phone")
    nonPermanentParamType: "string"
    nonPermanentVarCategory: "(global|const)"

    parametersModel: ListModel {

        onDataChanged:  setTitle()
        onCountChanged: setTitle()

    }

    Component.onCompleted: {
        parametersModel.append(
                    {
                        "paramName": qsTranslate("IncomingCall", "Authorized numbers"),
                        "paramType": categoryList,
                        "varCategory": categoryList,
                        "varName": "",
                        "isEditable": false,
                        "paramList" :
                            [{
                                "varName" : qsTranslate("IncomingCall", "Disabled"),
                                "desc"    : qsTranslate("IncomingCall", "Don\'t generate event for authorized numbers"),
                                "value"   : 0
                            },
                            {
                                "varName" : qsTranslate("IncomingCall", "Enabled"),
                                "desc"    : qsTranslate("IncomingCall", "Generate event for authorized numbers"),
                                "value"   : 1
                            }]
                    });
    }

    function setTitle() {
        var str = qsTr("IncomingCall:")
        var strNumbers = "";
        if (parametersModel.get(0).varName === qsTranslate("IncomingSMS", "Enabled"))
            strNumbers += qsTr("\nAuthorized numbers")
        var i;
        for (i = permanentParametersCount; i < parametersModel.count; ++i) {
            strNumbers += "\n" + parametersModel.get(i).varName;
        }

        if (strNumbers.length)
            actionTitle = str + qsTr("\nNumbers:") + strNumbers;
        else
            actionTitle = str + qsTr("\nNumbers: <ANY NUMBER>");
    }
}
