import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_GetUserArrayBytes"

    // unique for every action
    actionId: 0x23
    actionName: QT_TRANSLATE_NOOP("GetUserArrayBytes", "GetUserArrayBytes")
    actionTitle: qsTr("Get bytes from user array:\n???")
    actionToolTip: qsTr("Get bytes from user array")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("GetUserArrayBytes", "DstVar")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: false
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("GetUserArrayBytes", "Offset in array")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
        ListElement {
            paramName: QT_TRANSLATE_NOOP("GetUserArrayBytes", "Bytes count")
            paramType: "int"
            varCategory: "global"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var dstVarStr = parametersModel.get(0).varName
        var offsetStr = parametersModel.get(1).varName
	var countStr = parametersModel.get(2).varName

        if (dstVarStr.length === 0)
            dstVarStr = qsTr("???")

        if (offsetStr.length === 0)
            offsetStr = qsTr("???")

        if (countStr.length === 0)
            countStr = qsTr("???")
	    
        actionTitle = qsTr("Get %3 bytes from user array to %1\nstarting from %2").arg(dstVarStr).arg(offsetStr).arg(countStr)
    }
}
