import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableGsmUnit"

    // unique for every action
    actionId: 0x15
    actionName: QT_TRANSLATE_NOOP("EnableGsmUnit", "EnableGsmUnit")
    actionTitle: qsTr("GSM unit:\nEnable = ???")
    actionToolTip: qsTr("Enable GSM unit")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableGsmUnit", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable GSM unit");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable GSM unit");
        else
            actionTitle = qsTr("GSM unit:\nEnable = %1").arg(enableStr);
    }
}
