import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_EnableCANReception"

    // unique for every action
    actionId: 0x20
    actionName: QT_TRANSLATE_NOOP("EnableCANReception", "EnableCANReception")
    actionTitle: qsTr("CAN messages reception:\nEnable = ???")
    actionToolTip: qsTr("Enable CAN messages reception")

    parametersModel: ListModel {

        onDataChanged: { setTitle() }

        ListElement {
            paramName: QT_TRANSLATE_NOOP("EnableCANReception", "Enabled")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var enableStr = parametersModel.get(0).varName;

        if (enableStr === "0")
            actionTitle = qsTr("Disable CAN messages reception");
        else if (enableStr === "1")
            actionTitle = qsTr("Enable CAN messages reception");
        else
            actionTitle = qsTr("CAN messages reception:\nEnable = %1").arg(enableStr);
    }
}
