import QtQuick 2.0
import "lineItemCreation.js" as Code

Action {
    id: diagramAction
    objectName: "diagramAction_Delay"

    // unique for every action
    actionId: 0x03
    actionName: QT_TRANSLATE_NOOP("Delay", "Delay")
    actionTitle: qsTr("Delay:\n???")
    actionToolTip: qsTr("Stop execution for a number of milliseconds")

    parametersModel: ListModel {

        onDataChanged: setTitle()

        ListElement {
            paramName: QT_TRANSLATE_NOOP("Delay", "Delay [ms]")
            paramType: "int"
            varCategory: "(global|const)"
            varName: ""
            isEditable: true
        }
    }

    function setTitle() {
        var numberStr = parametersModel.get(0).varName

        if (numberStr.length === 0)
            numberStr = qsTr("???")

        actionTitle = qsTr("Delay %1 ms").arg(numberStr)
    }
}
